/* 
 * project: RT-ADKmini_Firmware_v1.2
 * 概要:   RT-ADKmini用ファームウェア
 *         APIレベル10-16まで対応
 *         Microchip Application Library v-2012-4-12をもとに構成
 *         2014 05/31 ver1.1に更新 ガイガーカウンターアプリに対応するため
 *         2014 07/12 ver1.2に更新 加速度センサアプリに対応するため
 * File:   main.c
 * 作者:   株式会社 アールティ
 *
 */

//Include files

#include "usb.h"
#include "usb_host_android.h"
#include "Compiler.h"
#include "HardwareProfile - RTADKmini.h"



// If a maximum current rating hasn't been defined, then define 500mA by default
#ifndef MAX_ALLOWED_CURRENT
	#define MAX_ALLOWED_CURRENT 			(500)		  // Maximum power we can supply in mA
#endif

// Define a debug error printing
#define DEBUG_ERROR(a)	 Nop(); Nop(); Nop();




//コンフィギュレーションの設定
_CONFIG1(WDTPS_PS1 & FWPSA_PR32 & WINDIS_OFF & FWDTEN_OFF & ICS_PGx1 & GWRP_OFF & GCP_OFF & JTAGEN_OFF)
_CONFIG2(POSCMOD_NONE & I2C1SEL_PRI & IOL1WAY_OFF & OSCIOFNC_ON & FCKSM_CSDCMD & FNOSC_FRCPLL & PLL96MHZ_ON & PLLDIV_DIV2 & IESO_OFF)
_CONFIG3(WPFP_WPFP0 & SOSCSEL_IO & WUTSEL_LEG & WPDIS_WPDIS & WPCFG_WPCFGDIS & WPEND_WPENDMEM)
_CONFIG4(DSWDTPS_DSWDTPS3 & DSWDTOSC_LPRC & RTCOSC_SOSC & DSBOREN_OFF & DSWDTEN_OFF)




//アンドロイドとやり取りするコマンド名の1byte目にはコマンド名が入る
typedef enum _ACCESSORY_DEMO_COMMANDS{
	COMMAND_OPEN_IO             = 1,      
	COMMAND_OPEN_AD             = 2,      
	COMMAND_OPEN_PWM0           = 3,
	COMMAND_OPEN_PWM1           = 4,
        COMMAND_OPEN_PWM2           = 5,
        COMMAND_OPEN_UART1          = 6,
        COMMAND_OPEN_RS485          = 7,
        COMMAND_OPEN_NORMAL_CONFIG  = 8,
        COMMAND_VERSION_QUERY       = 30,

        COMMAND_OPEN_GEIGER_CONFIG  = 50,
        COMMAND_OPEN_ACC_CONFIG     = 51,

        COMMAND_UPDATE_DIN          = 101,
        COMMAND_UPDATE_AIN0         = 102,
        COMMAND_UPDATE_AIN1         = 103,
        COMMAND_UPDATE_AIN2         = 104,
        COMMAND_UPDATE_AIN3         = 105,



        COMMAND_VERSION_SEND        = 130,

        COMMAND_UPDATE_GEIGER       = 150,
        COMMAND_UPDATE_ACC          = 151,

        COMMAND_WRITE_DOUT          = 201,
        COMMAND_SET_PWM0            = 202,
        COMMAND_SET_PWM1            = 203,
        COMMAND_SET_PWM2            = 204,
        COMMAND_SET_PWM0_FREQ       = 205,
        COMMAND_SET_PWM1_FREQ       = 206,
        COMMAND_SET_PWM2_FREQ       = 207,
        COMMAND_SET_PWM0_DUTY       = 208,
        COMMAND_SET_PWM1_DUTY       = 209,
        COMMAND_SET_PWM2_DUTY       = 210,
        COMMAND_WRITE_UART1         = 211,

} ACCESSORY_DEMO_COMMANDS;
//アンドロイドとやり取りするコマンドパケットを定義
//1byte目　　  : コマンド名
//2byte目　　  : コマンドパケットの長さ
//3byte目以降  : 送受信データ
typedef struct __attribute__((packed))
{
    BYTE command;
    BYTE length;
    BYTE data[256];

}ACCESSORY_APP_PACKET;

//変数宣言
static BYTE read_buffer[1024];
static ACCESSORY_APP_PACKET outgoing_packet;
static void* device_handle = NULL;
static BOOL device_attached = FALSE;

static char manufacturer[] = "RT CORPORATION";
static char model[] = "RT-ADKmini";
static char description[] = DEMO_BOARD_NAME_STRING;
static char version[] = "1.0";
unsigned char version_num = 120; //versionを100倍した値 上のversionは関係ない
static char uri[] = "http://rt-net.jp/";
static char serial[] = "N/A";

unsigned int AIN0_val_now, AIN1_val_now, AIN2_val_now, AIN3_val_now;   //ADCの読み取り値を格納する変数
WORD DIN_val_now = 0xFFFF;

ANDROID_ACCESSORY_INFORMATION myDeviceInfo =
{
	manufacturer,
	sizeof(manufacturer),
	model,
	sizeof(model),
	description,
	sizeof(description),
	version,
	sizeof(version),
	uri,
	sizeof(uri),
	serial,
	sizeof(serial)
};


//ガイガーカウンタ関係変数
unsigned int count_timer2        = 0;
char DIN1_pre                    = 0;
char DIN1_now                    = 0;
BOOL noise_flag                  = FALSE;
BOOL geigerNeedsUpdate           = FALSE;
unsigned char count_signal_now   = 0;
unsigned char count_signal_pre   = 0;

//加速度センサ関係変数
//加速度センサの使用フラグをHardwareProfile - RTADKmin.hで宣言していることに注意
//BOOL accUseFlag       = FALSE;  ←　これのこと
unsigned  char X_now_MSB  = 0;
unsigned  char Y_now_MSB  = 0;
unsigned  char Z_now_MSB  = 0;
unsigned  char X_now_LSB  = 0;
unsigned  char Y_now_LSB  = 0;
unsigned  char Z_now_LSB  = 0;

BOOL accNeedsUpdate   = FALSE;




//-----------------------------------------
int main(void)
{
    DWORD size;
    BOOL responseNeeded;

    unsigned int AIN0_val_pre = 0xFF;
    unsigned int AIN1_val_pre = 0xFF;
    unsigned int AIN2_val_pre = 0xFF;
    unsigned int AIN3_val_pre = 0xFF;

    BOOL DIN_NeedUpdate = FALSE;

    BOOL AIN0NeedsUpdate = FALSE;
    BOOL AIN1NeedsUpdate = FALSE;
    BOOL AIN2NeedsUpdate = FALSE;
    BOOL AIN3NeedsUpdate = FALSE;

    BOOL VERSIONSENDNeeds = TRUE;

    BOOL readInProgress = FALSE;
    BOOL writeInProgress = FALSE;
    WORD DIN_val_pre = 0xFFFF;
    BYTE errorCode;

    unsigned int pll_startup_counter = 600;

    ///////////////各種初期化//////////////////////////////
    CLKDIVbits.PLLEN = 1;
    while(pll_startup_counter--);
    CLKDIV = 0x0000;     // Set PLL prescaler (1:1)

    USBInitialize(0);
    AndroidAppStart(&myDeviceInfo);

    responseNeeded = FALSE;
    
    
    //タイマ1初期化(タイマ割り込み1に使用)
    T1CON = 0b1000000000110000;
    PR1 = 31250-1;	//500mSec
    PR1 = 3125-1;	//50mSec
    IPC0bits.T1IP = 5;	// 割り込みレベル 5
    IEC0bits.T1IE = 1; 	// Enable Int
    //////////////////////////////////////////////////////
    while(1)
    {
            //この関数をループの最初で呼ぶ必要がある
            USBTasks();
            //デバイスが接続されていない場合は変数を初期化してwhileループの最初に戻る
            if(device_attached == FALSE)
            {
                    DIN_NeedUpdate = TRUE;
                    AIN0NeedsUpdate = TRUE;
                    AIN1NeedsUpdate = TRUE;
                    AIN2NeedsUpdate = TRUE;
                    AIN3NeedsUpdate = TRUE;

                    continue;
            }

            if(readInProgress == FALSE)
            {
                    errorCode = AndroidAppRead(device_handle, (BYTE*)&read_buffer, (DWORD)sizeof(read_buffer));
                    //もしデバイスが接続されているなら,アプリケーションからのコマンドを待つ
                    if( errorCode != USB_SUCCESS)
                    {
                            //Error
                            DEBUG_ERROR("Error trying to start read");
                    }
                    else
                    {
                            readInProgress = TRUE;
                    }
            }

            //Android側からのコマンドの受信が成功したら実行
            if(AndroidAppIsReadComplete(device_handle, &errorCode, &size) == TRUE)
            {
                    readInProgress = FALSE;

                    if(errorCode == USB_SUCCESS)
                    {
                            ACCESSORY_APP_PACKET* command_packet = (ACCESSORY_APP_PACKET*)&read_buffer[0];

                            while(size > 0)
                            {
                                    switch(command_packet->command)
                                    {
                                            case COMMAND_VERSION_QUERY:
                                                VERSIONSENDNeeds = TRUE;        
                                                    break;
                                            case COMMAND_OPEN_IO:
                                                open_IO( *(WORD*)(command_packet->data) );
                                                    break;
                                            case COMMAND_OPEN_AD:
                                                open_AD();
                                                    break;
                                            case COMMAND_OPEN_PWM0:
                                                open_PWM0();
                                                    break;                                            
                                            case COMMAND_OPEN_PWM1:
                                                open_PWM1();                                    
                                                    break;
                                            case COMMAND_OPEN_PWM2:
                                                open_PWM2();
                                                    break;
                                            case COMMAND_OPEN_UART1:
                                                open_UART1( *(DWORD*)(command_packet->data) ,
                                                            (BOOL)(command_packet->data[4]) ,
                                                            (BYTE)(command_packet->data[5])
                                                          );
                                                    break;
                                            case COMMAND_OPEN_RS485:
                                                open_RS485();
                                                    break;
                                            case COMMAND_OPEN_NORMAL_CONFIG:
                                                open_normal_config();
                                                    break;
                                            
                                            case COMMAND_OPEN_GEIGER_CONFIG:
                                                open_geiger_config();
                                                    break;
                                            case COMMAND_OPEN_ACC_CONFIG:
                                                open_acc_config();
                                                    break;
                                            case COMMAND_WRITE_DOUT:
                                                write_DOUT( *(WORD*)(command_packet->data) );
                                                    break;

                                            case COMMAND_SET_PWM0:
                                                set_PWM0( *(WORD*)(command_packet->data)    ,
                                                          *(WORD*)(command_packet->data[2]) ,
                                                          (BYTE)command_packet->data[4]
                                                        );
                                                    break;
                                            case COMMAND_SET_PWM1:
                                                set_PWM1( *(WORD*)(command_packet->data)    ,
                                                          *(WORD*)(command_packet->data[2]) ,
                                                          (BYTE)command_packet->data[4]
                                                        );
                                                    break;
                                            case COMMAND_SET_PWM2:
                                                set_PWM2( *(WORD*)(command_packet->data)    ,
                                                          *(WORD*)(command_packet->data[2]) ,
                                                          (BYTE)command_packet->data[4]
                                                        );
                                                    break;

                                            case COMMAND_SET_PWM0_FREQ:
                                                set_PWM0_freq( *(DWORD*)(command_packet->data) );
                                                    break;
                                            case COMMAND_SET_PWM1_FREQ:
                                                set_PWM1_freq( *(DWORD*)(command_packet->data) );
                                                    break;
                                            case COMMAND_SET_PWM2_FREQ:
                                                set_PWM2_freq( *(DWORD*)(command_packet->data) );
                                                    break;

                                            case COMMAND_SET_PWM0_DUTY:
                                                set_PWM0_duty( (BYTE)(command_packet->data[0]) );
                                                    break;
                                            case COMMAND_SET_PWM1_DUTY:
                                                set_PWM1_duty( (BYTE)(command_packet->data[0]) );
                                                    break;
                                            case COMMAND_SET_PWM2_DUTY:
                                                set_PWM2_duty( (BYTE)(command_packet->data[0]) );
                                                    break;
                                            case COMMAND_WRITE_UART1:
                                             
                                                write_UART1(command_packet->data ,
                                                            command_packet->length - 2
                                                           );
                                                    break;

                                            default:
                                                //Error, unknown command
                                                DEBUG_ERROR("Error: unknown command received");
                                                    break;
                                    }
                                    //パケットの長さだけqueueを除去する
                                    size -= command_packet->length;
                                    //command_packetのポインタを次のパケットにずらす
                                    command_packet += command_packet->length;
                            }
                    }
                    else
                    {
                        //Error
                        DEBUG_ERROR("Error trying to complete read request");
                    }

            }


            //現在のボタンの押下状況を前回のボタン押下状況と比較
            if(DIN_val_now != DIN_val_pre)
            {
                    DIN_NeedUpdate = TRUE;
                    DIN_val_pre = DIN_val_now;
            }

            //現在のAD値と前回のAD値を比較
            if(AIN0_val_now != AIN0_val_pre)
            {
                    AIN0NeedsUpdate = TRUE;
                    AIN0_val_pre = AIN0_val_now;
            }


            if(AIN1_val_now != AIN1_val_pre)
            {
                    AIN1NeedsUpdate = TRUE;
                    AIN1_val_pre = AIN1_val_now;
            }


            if(AIN2_val_now != AIN2_val_pre)
            {
                    AIN2NeedsUpdate = TRUE;
                    AIN2_val_pre = AIN2_val_now;
            }


            if(AIN3_val_now != AIN3_val_pre)
            {
                    AIN3NeedsUpdate = TRUE;
                    AIN3_val_pre = AIN3_val_now;
            }

            //Androidへのデータの送信状況をチェック
            if( writeInProgress == TRUE )
            {
                    if(AndroidAppIsWriteComplete(device_handle, &errorCode, &size) == TRUE)
                    {
                            writeInProgress = FALSE;

                            if(errorCode != USB_SUCCESS)
                            {
                                    //Error
                                    DEBUG_ERROR("Error trying to complete write");
                            }
                    }
            }


            if((VERSIONSENDNeeds == TRUE) && (writeInProgress == FALSE))
            {
                    //パケットへデータの格納をする

                    outgoing_packet.command = COMMAND_VERSION_SEND;               //コマンド名を格納
                    outgoing_packet.length = 3;                          
                    outgoing_packet.data[0] = version_num;     
             
                    
                    errorCode = AndroidAppWrite(device_handle,(BYTE*)&outgoing_packet, outgoing_packet.length);
                    if( errorCode != USB_SUCCESS )
                    {
                            DEBUG_ERROR("Error trying to send button update");
                    }

                    VERSIONSENDNeeds = FALSE;
                    writeInProgress  = TRUE;
            }
            //ボタンの更新が必要でかつAndroid側にデータ送信中でないならば,ボタンの
            //状況の更新をAndroid側に送る
            if((DIN_NeedUpdate == TRUE) && (writeInProgress == FALSE))
            {
                    //パケットへデータの格納をする
                    outgoing_packet.command = COMMAND_UPDATE_DIN;               //コマンド名を格納
                    outgoing_packet.length = 4;                          //data部分が2byteなので、パケット長は4byte
                    outgoing_packet.data[0] = (BYTE)(DIN_val_pre & 0x00ff);     //DIN_val_nowはword型なので下位byteと
                    outgoing_packet.data[1] = (BYTE)((DIN_val_pre & 0xff00)>>8);//上位byteに分けて格納
                    
                    errorCode = AndroidAppWrite(device_handle,(BYTE*)&outgoing_packet, outgoing_packet.length);
                    if( errorCode != USB_SUCCESS )
                    {
                            DEBUG_ERROR("Error trying to send button update");
                    }

                    DIN_NeedUpdate = FALSE;
                    writeInProgress = TRUE;
            }

            //AD値の更新が必要でかつAndroid側にデータ送信をしていないならば,AD値の
            //状況の更新をAndroid側に送る
            if((AIN0NeedsUpdate == TRUE) && (writeInProgress == FALSE))
            {
                    outgoing_packet.command = COMMAND_UPDATE_AIN0;
                    outgoing_packet.length = 3;
                    outgoing_packet.data[0] = (BYTE)AIN0_val_pre;

                    errorCode = AndroidAppWrite(device_handle,(BYTE*)&outgoing_packet, outgoing_packet.length);
                    if( errorCode != USB_SUCCESS )
                    {
                            DEBUG_ERROR("Error trying to send pot update");
                    }

                    AIN0NeedsUpdate = FALSE;
                    writeInProgress = TRUE;
            }
            if((AIN1NeedsUpdate == TRUE) && (writeInProgress == FALSE))
            {
                    outgoing_packet.command = COMMAND_UPDATE_AIN1;
                    outgoing_packet.length = 3;
                    outgoing_packet.data[0] = (BYTE)AIN1_val_pre;

                    errorCode = AndroidAppWrite(device_handle,(BYTE*)&outgoing_packet, outgoing_packet.length);
                    if( errorCode != USB_SUCCESS )
                    {
                            DEBUG_ERROR("Error trying to send pot update");
                    }

                    AIN1NeedsUpdate = FALSE;
                    writeInProgress = TRUE;
            }
            if((AIN2NeedsUpdate == TRUE) && (writeInProgress == FALSE))
            {
                    outgoing_packet.command = COMMAND_UPDATE_AIN2;
                    outgoing_packet.length = 3;
                    outgoing_packet.data[0] = (BYTE)AIN2_val_pre;

                    errorCode = AndroidAppWrite(device_handle,(BYTE*)&outgoing_packet, outgoing_packet.length);
                    if( errorCode != USB_SUCCESS )
                    {
                            DEBUG_ERROR("Error trying to send pot update");
                    }

                    AIN2NeedsUpdate = FALSE;
                    writeInProgress = TRUE;
            }
            if((AIN3NeedsUpdate == TRUE) && (writeInProgress == FALSE))
            {
                    outgoing_packet.command = COMMAND_UPDATE_AIN3;
                    outgoing_packet.length = 3;
                    outgoing_packet.data[0] = (BYTE)AIN3_val_pre;

                    errorCode = AndroidAppWrite(device_handle,(BYTE*)&outgoing_packet, outgoing_packet.length);
                    if( errorCode != USB_SUCCESS )
                    {
                            DEBUG_ERROR("Error trying to send pot update");
                    }

                    AIN3NeedsUpdate = FALSE;
                    writeInProgress = TRUE;
            }

            //ガイガーカウンターの計測データを送信する必要がありかつAndroid側にデータ送信をしていないならば,
            //計測データをAndroid側に送る
            if((geigerNeedsUpdate == TRUE) && (writeInProgress == FALSE))
            {
                    outgoing_packet.command = COMMAND_UPDATE_GEIGER;
                    outgoing_packet.length = 3;
                    outgoing_packet.data[0] = (BYTE)count_signal_pre;

                    errorCode = AndroidAppWrite(device_handle,(BYTE*)&outgoing_packet, outgoing_packet.length);
                    if( errorCode != USB_SUCCESS )
                    {
                            DEBUG_ERROR("Error trying to send pot update");
                    }

                    geigerNeedsUpdate = FALSE;
                    writeInProgress = TRUE;
            }

            //加速度センサの計測データを送信する必要がありかつAndroid側にデータを送信していないならば,
            //計測データをAndroid側に送る
            if((accNeedsUpdate == TRUE) && (writeInProgress == FALSE) )
            {
                    outgoing_packet.command = COMMAND_UPDATE_ACC;
                    outgoing_packet.length  = 8;
                    outgoing_packet.data[0] = (BYTE)X_now_MSB;
                    outgoing_packet.data[1] = (BYTE)Y_now_MSB;
                    outgoing_packet.data[2] = (BYTE)Z_now_MSB;
                    outgoing_packet.data[3] = (BYTE)X_now_LSB;
                    outgoing_packet.data[4] = (BYTE)Y_now_LSB;
                    outgoing_packet.data[5] = (BYTE)Z_now_LSB;


                    errorCode = AndroidAppWrite(device_handle,(BYTE*)&outgoing_packet, outgoing_packet.length);
                    if( errorCode != USB_SUCCESS )
                    {
                            DEBUG_ERROR("Error trying to send pot update");
                    }

                    accNeedsUpdate = FALSE;
                    writeInProgress = TRUE;
            }



	} //while(1) main loop
}





///////////usb_host_android.hでプロトタイプ宣言されている///////////////
//-----------------------------------------
BOOL USB_ApplicationDataEventHandler( BYTE address, USB_EVENT event, void *data, DWORD size )
{
	return FALSE;
}
//-----------------------------------------
BOOL USB_ApplicationEventHandler( BYTE address, USB_EVENT event, void *data, DWORD size )
{
	switch( event )
	{
		case EVENT_VBUS_REQUEST_POWER:

			if (((USB_VBUS_POWER_EVENT_DATA*)data)->current <= (MAX_ALLOWED_CURRENT / 2))
			{
				return TRUE;
			}
			else
			{
				DEBUG_ERROR( "\r\n***** USB Error - device requires too much current *****\r\n" );
			}
			break;

		case EVENT_VBUS_RELEASE_POWER:
		case EVENT_HUB_ATTACH:
		case EVENT_UNSUPPORTED_DEVICE:
		case EVENT_CANNOT_ENUMERATE:
		case EVENT_CLIENT_INIT_ERROR:
		case EVENT_OUT_OF_MEMORY:
		case EVENT_UNSPECIFIED_ERROR:
		case EVENT_DETACH:		     // USBのケーブルが未接続
		case EVENT_ANDROID_DETACH:
                        asm("reset");   //接続が寸断されたときはソフトウェアリセットをかける.
                        device_attached = FALSE;
			return TRUE;
			break;

		// Android Specific events
		case EVENT_ANDROID_ATTACH:
			device_attached = TRUE;
			device_handle = data;
			return TRUE;

		default :
			break;
	}
	return FALSE;
}
//////////////////////////////////////////////////////////////////////////////



// ADC1割り込み関数/////////////////////////////////////////////////////////////////
void __attribute__((interrupt, auto_psv)) _ADC1Interrupt(void)
{
     IFS0bits.AD1IF = 0;         //フラグクリア
        AIN0_val_now = ((ADC1BUF0 + ADC1BUF4 + ADC1BUF8)/3)>>2;
	AIN1_val_now = ((ADC1BUF1 + ADC1BUF5 + ADC1BUF9)/3)>>2;
	AIN2_val_now = ((ADC1BUF2 + ADC1BUF6 + ADC1BUFA)/3)>>2;
	AIN3_val_now = ((ADC1BUF3 + ADC1BUF7 + ADC1BUFB)/3)>>2;
    //三回のAD変換値の平均を2bitシフトしているのは、アンドロイドとやりとりしているデータのパケットが1byteのため
    //実際の分解能は10bit
}
//  タイマ1割り込み関数////////////////////////////////////////////////////////////////
void __attribute__((interrupt, no_auto_psv)) _T1Interrupt(void)
{
     IFS0bits.T1IF = 0;			//フラグクリア
     //現在のデジタル入力ピンの状態を変数にセット
     DIN_val_now = read_DIN();

      if(accUseFlag == TRUE ){
      
           X_now_MSB = readRegister(0x01);
           X_now_LSB = readRegister(0x02);

           Y_now_MSB = readRegister(0x03);
           Y_now_LSB = readRegister(0x04);

           Z_now_MSB = readRegister(0x05);
           Z_now_LSB = readRegister(0x06);
           accNeedsUpdate = TRUE;
           

      }


}
//  タイマ2割り込み関数////////////////////////////////////////////////////////////////
void __attribute__((interrupt, no_auto_psv)) _T2Interrupt(void)
{
    count_timer2 ++;     //割り込み関数に入った回数をカウント200msec毎に0に戻す
    IFS0bits.T2IF = 0;			//フラグクリア
    //現在のデジタル入力ピンの状態を変数にセット
    DIN1_pre = DIN1_now;
    DIN1_now = PORTAbits.RA3;

    if(DIN1_pre == 0 && DIN1_now == 1) count_signal_now++;

    if(noise_flag == 0 && PORTBbits.RB4 == 1) noise_flag =1;

    if(count_timer2 == 40000){ //40000回で200msec
        if(noise_flag == TRUE){
            count_signal_now = 0;
        }
        //カウントした放射線数等をリセット
        count_signal_pre = count_signal_now;
        count_signal_now = 0;
        noise_flag   = 0;
        count_timer2 = 0;
        geigerNeedsUpdate = TRUE;
    }

}



